function gr = Calgr(v1,v2)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%% Caculate the Raman Gain Coefficient %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

gp1=[-5.46330402711776468*1e-9...
     3.60523438158901019*1e-7...
     -1.01921039014804243*1e-5...
     0.000160333597184347916...
     -0.00151941702992432601...
     0.00870150194884484687...
     -0.0280906788987400249...
     0.0410852974339794572...
     -0.00735413504582861299...
     0.0364360297690974019...
     0.000801309666226117752];
% ----------------------------------------- %
gpnum=[2.32220421848846868*1e-6...
       -0.000154005471146799608...
       0.00383413081296760536...
       -0.0424483399416773737...
       0.176261228215402518];
gpden=[-9.13350764406426683*1e-7...
       7.37686787980130225*1e-5...
       -0.00237910697604905564...
       0.0383513278927860977...
       -0.309367640642767183...
       1];
% ----------------------------------------- %
gp2=[-3.07652391850639023*1e-11...
     6.51858494944691109*1e-9...
     -5.91354165062821035*1e-7...
     2.99764991570054746*1e-5...
     -0.000936416559266907086...
     0.01928555003788814369...
     -0.29831746001094976...
     4.34072461232012817...
     -59.5510218486987634...
     551.631362711035864...
     -2243.94411363145624];
% ----------------------------------------- %


dv=(v1-v2)*1e-12;
if abs(dv)>=0 && abs(dv)<=12.6470593512058
    
    gr=polyval(gp1,abs(dv))*1e-13;
    
elseif abs(dv)>12.6470593512058 && abs(dv)<=18.7294125378132 
    
    gr=polyval(gpnum,abs(dv))/polyval(gpden,abs(dv))*1e-13;
    
elseif abs(dv)>18.7294125378132  && abs(dv)<=34 
    
    gr=polyval(gp2,abs(dv))*1e-13;
    
elseif  abs(dv)>34 
    
    gr=0;


end


end

